% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{zip_process}
\alias{zip_process}
\title{Class for an external zip process}
\usage{
zip_process()
}
\value{
A \code{zip_process} R6 class object, a subclass of
\link[processx:process]{processx::process}.
}
\description{
\code{zip_process()} returns an R6 class that represents a zip process.
It is implemented as a subclass of \link[processx:process]{processx::process}.
}
\section{Using the \code{zip_process} class}{
\preformatted{zp <- zip_process()$new(zipfile, files, recurse = TRUE)
}

See \link[processx:process]{processx::process} for the class methods.

Arguments:
\itemize{
\item \code{zipfile}: Path to the zip file to create.
\item \code{files}: List of file to add to the archive. Each specified file
or directory in is created as a top-level entry in the zip archive.
\item \code{recurse} Whether to add the contents of directories recursively.
}
}

\examples{
dir.create(tmp <- tempfile())
write.table(iris, file = file.path(tmp, "iris.ssv"))
zipfile <- tempfile(fileext = ".zip")
zp <- zip_process()$new(zipfile, tmp)
zp$wait()
zp$get_exit_status()
zip_list(zipfile)
}
