% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsmmviterbi2.R
\name{hsmmviterbi2}
\alias{hsmmviterbi2}
\title{Viterbi algorithm to decode the latent states in hidden semi-Markov models
with covariates}
\usage{
hsmmviterbi2(y, ntimes = NULL, M, trunc, workparm,
  dt_dist = "nonparametric", zero_init, prior_x = NULL, tpm_x = NULL,
  emit_x = NULL, zeroinfl_x = NULL, dt_x = NULL, plot = FALSE,
  xlim = NULL, ylim = NULL, ...)
}
\arguments{
\item{y}{the observed series to be decoded}

\item{ntimes}{vector specifying the lengths of individual, 
i.e. independent, time series. If not specified, the responses are assumed to 
form a single time series, i.e. ntimes=length(y)}

\item{M}{number of latent states}

\item{trunc}{a vector specifying the truncation at the maximum number of dwelling time 
in each state.}

\item{workparm}{working parameters. The first part is the logit of parameter p for 
each log-series dwell time distribution or the log of parameter theta for each 
shifted-poisson dwell time distribution. If dt_dist is "nonparametric", then the first
part is empty. The next part is the generalized logit of prior probabilities (except for 
the 1st state),the logit of each nonzero structural zero proportions, the log of each 
state-dependent poisson means, and the generalized logit of the transition probability 
matrix(except 1st column and the diagonal elements).}

\item{dt_dist}{dwell time distribution, can only be "log", "shiftedpoisson" or
"nonparametric". Default to "nonparametric".}

\item{zero_init}{a vector containing structural zero proportions in each state, e.g. set
zero_init[i] to be 0 if the i-th state is a regular poisson, and otherwise 1.}

\item{prior_x}{matrix of covariates for generalized logit of prior probabilites (excluding the 
1st probability). Default to NULL.}

\item{tpm_x}{matrix of covariates for transition probability matrix (excluding the 1st column).
Default to NULL.}

\item{emit_x}{matrix of covariates for the log poisson means. Default to NULL.}

\item{zeroinfl_x}{matrix of covariates for the nonzero structural zero proportions. Default to NULL.}

\item{dt_x}{if dt_dist is "nonparametric", then dt_x is the matrix of nonparametric 
state durataion probabilities. Otherwise, dt_x is matrix of covariates for the dwell time distribution 
parameters in log-series or shifted-poisson distributions.Default to NULL.}

\item{plot}{whether a plot should be returned}

\item{xlim}{vector specifying the minimum and maximum on the x-axis in the plot. 
Default to NULL.}

\item{ylim}{vector specifying the minimum and maximum on the y-axis in the plot. 
Default to NULL.}

\item{...}{further arguments to be passed to the plot() function}
}
\value{
decoded series of latent states
}
\description{
Viterbi algorithm to decode the latent states in hidden semi-Markov models
with covariates
}
\examples{

\dontrun{
data(CAT)
y <- CAT$activity
x <- data.matrix(CAT$night)
prior_init <- c(0.5,0.3,0.2)
dt_init <- c(0.9,0.6,0.3)
emit_init <- c(10,50,100)
zero_init <- c(0.5,0,0) #assuming only the 1st state has structural zero's
tpm_init <- matrix(c(0,0.3,0.7,0.4,0,0.6,0.5,0.5,0),3,3,byrow=TRUE)
trunc <- c(10,7,4)
fit2 <-  hsmmfit(y,rep(1440,3),3,trunc,prior_init,"log",dt_init,tpm_init,
     emit_init,zero_init,emit_x=x,zeroinfl_x=x,hessian=FALSE,
     method="Nelder-Mead", control=list(maxit=500,trace=1))
decode <- hsmmviterbi2(y,rep(1440,3),3,trunc,fit2$working_parameters,
            dt_dist="log", zero_init=c(1,0,0),
            emit_x=x,zeroinfl_x=x, plot=TRUE, xlab="time", ylab="count",
            xlim=c(0,360),ylim=c(0,200))
}
}
\references{
Walter Zucchini, Iain L. MacDonald, Roland Langrock. Hidden Markov Models for 
Time Series: An Introduction Using R, Second Edition. Chapman & Hall/CRC
}
