% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipsae.R
\name{zipsae}
\alias{zipsae}
\title{EBLUPs under Zero-Inflated Poisson Model}
\usage{
zipsae(data, vardir, formula, PRECISION = 1e-04, MAXITER = 100)
}
\arguments{
\item{data}{The data frame with vardir, response, and explanatory variables included with Zero-Inflated situation also.}

\item{vardir}{Sampling variances of direct estimations, if it is included in data frame so it is the vector with the name of sampling variances.if it is not, it is a data frame of sampling variance in order : \code{var1, cov12,.,cov1r,var2,cov23,.,cov2r,.,cov(r-1)(r),var(r)}}

\item{formula}{List of formula that describe the fitted model}

\item{PRECISION}{Limit of Fisher-scoring convergence tolerance. We set the default in \code{1e-4}}

\item{MAXITER}{Maximum number of iterations in Fisher-scoring algorithm. We set the default in \code{100}}
}
\value{
This function returns a list of the following objects:
   \item{estimate}{A Vector with a list of EBLUP with Zero-Inflated Poisson model}
   \item{dispersion}{A list containing the following objects:}
     \itemize{
       \item rse : A dataframe with the values of relative square errors of estimation
     }
   \item{coefficient}{A list containing the following objects:}
     \itemize{
       \item a : EBLUP estimator for Non-Zero data
       \item b : EBLUP estimator for Complete Data
     }
}
\description{
This function produce EBLUPs for Zero-Inflated data and its Relative Standard Error. Small Area Estimation with Zero-Inflated Model (SAE-ZIP) is a model developed for Zero-Inflated data that can lead us to overdispersion situation. To handle this kind of situation, this model is created. The model in this package is based on Small Area Estimation with Zero-Inflated Poisson model proposed by Dian Christien Arisona (2018). For the data sample itself, we use combination method between Roberto Benavent and Domingo Morales (2015) and Sabine Krieg, Harm Jan Boonstra and Marc Smeets (2016).
}
\examples{
##load the dataset in package
data(dataSAEZIP)

##Extract the vardir (sampling error)
dataSAEZIP$vardir -> sError

##Compute the data with SAE ZIP model
formula = (y~x1)
zipsae(data = dataSAEZIP, vardir = sError, formula) -> saezip

saezip$estimate        #to see the result of Small Area Estimation with Zero-Inflated Model
saezip$dispersion$rse  #to see the relative standard error from the estimation
saezip$coefficient$a   #to see the a coefficient which is gained from the non-zero compilation data
saezip$coefficient$b   #to see the b coefficient which is gained from the complete compilation data.

head(saezip)

}
