% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlib.R
\name{compressobj}
\alias{compressobj}
\title{Create a Compression Object}
\usage{
compressobj(
             level = -1,
             method = zlib$DEFLATED,
             wbits = zlib$MAX_WBITS,
             memLevel = zlib$DEF_MEM_LEVEL,
             strategy = zlib$Z_DEFAULT_STRATEGY,
             zdict = NULL
         )
}
\arguments{
\item{level}{Compression level, default is -1.}

\item{method}{Compression method, default is \code{zlib$DEFLATED}.}

\item{wbits}{Window bits, default is \code{zlib$MAX_WBITS}.}

\item{memLevel}{Memory level, default is \code{zlib$DEF_MEM_LEVEL}.}

\item{strategy}{Compression strategy, default is \code{zlib$Z_DEFAULT_STRATEGY}.}

\item{zdict}{Optional predefined compression dictionary as a raw vector.}
}
\value{
Returns an environment containing the public methods \code{compress} and \code{flush}.
}
\description{
\code{compressobj} initializes a new compression object with specified parameters
and methods. The function makes use of \code{publicEval} to manage scope and encapsulation.
}
\section{Methods}{

\itemize{
\item \code{compress(data)}: Compresses a chunk of data.
\item \code{flush()}: Flushes the compression buffer.
}
}

\examples{
compressor <- compressobj(level = 6)
compressed_data <- compressor$compress(charToRaw("some data"))
compressed_data <- c(compressed_data, compressor$flush())

}
