% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup_limits.R
\name{lookup_limits}
\alias{lookup_limits}
\title{Lookup Limits in Reference Tables}
\usage{
lookup_limits(age, sex, table)
}
\arguments{
\item{age}{\code{numeric}, patient age.}

\item{sex}{\code{character}/\code{factor}, patient sex, has to be the same length as
\code{age}.}

\item{table}{\code{data.frame}, reference table, has to have the columns:
"age", \code{numeric} (same units as in \code{age}, e.g. days or years, age of \code{0}
matches all ages),
"sex", \code{factor} (same levels for male and female as \code{sex} and a special level
\code{"both"}), "lower" and "upper", \code{numeric} for the lower and upper reference
limits. If an "param" column is given the "lower" and "upper" limits for all
different values in "param" is returned. Additional columns are allowed (and
ignored).}
}
\value{
\code{matrix}, with 2 columns ("lower", "upper") and as many rows as
\code{length(age)}.
}
\description{
Reference limits are specific for age and sex. Each laboratory institute has
its own reference limits. This function is useful to query a dataset against
this database.
}
\examples{
reference <- data.frame(
    param = c("albumin", rep("bilirubin", 4)),
    age = c(0, 1, 2, 3, 7),     # days
    sex = "both",
    units = c("g/l", rep("µmol/l", 4)), # ignored
    lower = c(35, rep(NA, 4)),  # no real reference values
    upper = c(52, 5, 8, 13, 18) # no real reference values
)

# lookup albumin reference values for 18 year old woman
lookup_limits(
    age = 18 * 365.25,
    sex = "female",
    table = reference[reference$param == "albumin",]
)

# lookup albumin and bilirubin values for 18 year old woman
lookup_limits(
    age = 18 * 365.25,
    sex = "female",
    table = reference
)

# lookup bilirubin referenc values for infants
lookup_limits(
    age = 0:8,
    sex = rep(c("female", "male"), 5:4),
    table = reference[reference$param == "bilirubin",]
)
}
\author{
Sebastian Gibb
}
