% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doughut.R
\name{zb_doughnut}
\alias{zb_doughnut}
\title{Make doughnuts}
\usage{
zb_doughnut(
  x = NULL,
  area = NULL,
  n_circles = NA,
  distance = 1,
  distance_growth = 1
)
}
\arguments{
\item{x}{Centre point. Should be an \code{\link[sf:sf]{sf}} or \code{\link[sf:sfc]{sfc}} object containing one point, or a name of a city (which is looked up with OSM geocoding).}

\item{area}{(optional) Area. Should be an \code{\link[sf:sf]{sf}} or \code{\link[sf:sfc]{sfc}} object containing one (multi) polygon}

\item{n_circles}{Number of rings including the central circle. By default 5, unless \code{area} is specified (then it is set automatically to fill the area).}

\item{distance}{Distance The distances between the circles. For the center circle, it is the distance between the center and the circle. If only one number is specified, \code{distance_growth} determines the increment at which the distances grow for the outer circles.}

\item{distance_growth}{The rate at which the distances between the circles grow. Only applicable when \code{distance} is one number and \code{n_circles > 1}. See also \code{distance}.}
}
\value{
An `sf` data frame
}
\description{
Make doughnuts
}
\examples{
zb_plot(zb_doughnut(london_c(), london_a()))
}
