% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_col.R
\name{apply_col}
\alias{apply_col}
\alias{apply_col.zoocat}
\title{Apply functions over each column}
\usage{
apply_col(x, ...)

\method{apply_col}{zoocat}(x, FUN, col.as = "vector", ...)
}
\arguments{
\item{x}{A object.}

\item{...}{Additional arguments to be passed to or from methods.}

\item{FUN}{The function apply for each column.}

\item{col.as}{If vector, each column will be treated as a vector. If 
zoo, each column will be treated as a zoo object.}
}
\value{
a data frame.
}
\description{
Apply a function over each column of a "\code{zoocat}" object
and return a data frame.
}
\examples{
x <- matrix(1 : 20, nrow = 5)
colAttr <- data.frame(month = c(2, 3, 5, 6), name = c(rep('xxx', 3), 'yyy'))
zc <- zoocat(x, order.by = 1991 : 1995, colattr = colAttr)
apply_col(zc, FUN = mean, col.as = 'vector')
apply_col(zc, FUN = max, col.as = 'vector')

 
}

