


use crate::dimension::Dim;
use crate::{ArcArray, Array, ArrayView, ArrayViewMut, Ix, IxDynImpl};


#[allow(non_snake_case)]
#[inline(always)]
pub fn Ix0() -> Ix0 {
    Dim::new([])
}

#[allow(non_snake_case)]
#[inline(always)]
pub fn Ix1(i0: Ix) -> Ix1 {
    Dim::new([i0])
}

#[allow(non_snake_case)]
#[inline(always)]
pub fn Ix2(i0: Ix, i1: Ix) -> Ix2 {
    Dim::new([i0, i1])
}

#[allow(non_snake_case)]
#[inline(always)]
pub fn Ix3(i0: Ix, i1: Ix, i2: Ix) -> Ix3 {
    Dim::new([i0, i1, i2])
}

#[allow(non_snake_case)]
#[inline(always)]
pub fn Ix4(i0: Ix, i1: Ix, i2: Ix, i3: Ix) -> Ix4 {
    Dim::new([i0, i1, i2, i3])
}

#[allow(non_snake_case)]
#[inline(always)]
pub fn Ix5(i0: Ix, i1: Ix, i2: Ix, i3: Ix, i4: Ix) -> Ix5 {
    Dim::new([i0, i1, i2, i3, i4])
}

#[allow(non_snake_case)]
#[inline(always)]
pub fn Ix6(i0: Ix, i1: Ix, i2: Ix, i3: Ix, i4: Ix, i5: Ix) -> Ix6 {
    Dim::new([i0, i1, i2, i3, i4, i5])
}


#[allow(non_snake_case)]
#[inline(always)]
pub fn IxDyn(ix: &[Ix]) -> IxDyn {
    Dim(ix)
}


pub type Ix0 = Dim<[Ix; 0]>;

pub type Ix1 = Dim<[Ix; 1]>;

pub type Ix2 = Dim<[Ix; 2]>;

pub type Ix3 = Dim<[Ix; 3]>;

pub type Ix4 = Dim<[Ix; 4]>;

pub type Ix5 = Dim<[Ix; 5]>;

pub type Ix6 = Dim<[Ix; 6]>;




























pub type IxDyn = Dim<IxDynImpl>;


pub type Array0<A> = Array<A, Ix0>;

pub type Array1<A> = Array<A, Ix1>;

pub type Array2<A> = Array<A, Ix2>;

pub type Array3<A> = Array<A, Ix3>;

pub type Array4<A> = Array<A, Ix4>;

pub type Array5<A> = Array<A, Ix5>;

pub type Array6<A> = Array<A, Ix6>;

pub type ArrayD<A> = Array<A, IxDyn>;


pub type ArrayView0<'a, A> = ArrayView<'a, A, Ix0>;

pub type ArrayView1<'a, A> = ArrayView<'a, A, Ix1>;

pub type ArrayView2<'a, A> = ArrayView<'a, A, Ix2>;

pub type ArrayView3<'a, A> = ArrayView<'a, A, Ix3>;

pub type ArrayView4<'a, A> = ArrayView<'a, A, Ix4>;

pub type ArrayView5<'a, A> = ArrayView<'a, A, Ix5>;

pub type ArrayView6<'a, A> = ArrayView<'a, A, Ix6>;

pub type ArrayViewD<'a, A> = ArrayView<'a, A, IxDyn>;


pub type ArrayViewMut0<'a, A> = ArrayViewMut<'a, A, Ix0>;

pub type ArrayViewMut1<'a, A> = ArrayViewMut<'a, A, Ix1>;

pub type ArrayViewMut2<'a, A> = ArrayViewMut<'a, A, Ix2>;

pub type ArrayViewMut3<'a, A> = ArrayViewMut<'a, A, Ix3>;

pub type ArrayViewMut4<'a, A> = ArrayViewMut<'a, A, Ix4>;

pub type ArrayViewMut5<'a, A> = ArrayViewMut<'a, A, Ix5>;

pub type ArrayViewMut6<'a, A> = ArrayViewMut<'a, A, Ix6>;

pub type ArrayViewMutD<'a, A> = ArrayViewMut<'a, A, IxDyn>;


pub type ArcArray1<A> = ArcArray<A, Ix1>;

pub type ArcArray2<A> = ArcArray<A, Ix2>;
