% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttest_data.R
\name{ttest_data}
\alias{ttest_data}
\title{applying t-test analysis}
\usage{
ttest_data(x, cases_column_1, cases_column_n, controls_column_1,
  controls_column_n, ttest_cutoff)
}
\arguments{
\item{x}{The filtered 450k probes from filter_data() function}

\item{cases_column_1}{The first column (column number) for cases in the filtered dataset}

\item{cases_column_n}{The last column (column number) for cases in the filtered dataset}

\item{controls_column_1}{The first column (column number) for controls in the filtered dataset}

\item{controls_column_n}{The last column (column number) for controls in the filtered dataset}

\item{ttest_cutoff}{The cutoff level to filter insignificant p-values}
}
\description{
This function applies "two.sided", unequal variance Student's t-test analysis for each probe comparing cases and controls. A cutoff for p-values can be entered to minimise multiple testing bias to filter insignificant p-values.
}
\examples{
data(test_data)
data(nonspecific_probes)
test_data_filtered <- filter_data(test_data)
test_data_ttest <- ttest_data(test_data_filtered, 1, 2, 3, 4, 1e-3)

}

