% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{insert_reference}
\alias{insert_reference}
\title{Insert references into help files}
\usage{
insert_reference(name, tbl_ref_name = "tbl_ref")
}
\arguments{
\item{name}{character, The name of the score to insert the reference for.}

\item{tbl_ref_name}{character, The name of the reference table object in the
environment.}
}
\value{
character (vector). The reference in markdown format.
}
\description{
Inserts references into help files in markdown format. The function takes
the a single score name and returns the reference in markdown format.
}
\details{
It is expected to have a table with the following columns in environment:
\itemize{
\item \code{name}: The name of the scores
\item \code{authors}: The authors of the paper
\item \code{year}: The year of publication
\item \code{title}: The title of the paper
\item \code{journal}: The journal where the paper was published
\item \code{volume_page}: The volume and page number of the paper, optional, can be
\code{""} if not available
\item \code{doi}: The DOI of the paper, optional, can be \code{""} if not available
}
}
\examples{
tbl_ref <- tibble::tibble(
  name = c("score1", "score1", "score2"),
  authors = c(
    "Smith, B., Jones, A.",
    "Simon, J., Norman, D. A.",
    "Smith, B., Jones, A., Simon, J., Norman, D. A."
  ),
  year = c(2020, 2021, 2022),
  title = c(
    "Title of the First Paper",
    "Title of the Second Paper",
    "Title of the Third Paper"
  ),
  journal = c("Journal A", "Journal B", "Journal C"),
  volume_page = c("1(1): 1-10", "", "3(3): 21-30"),
  doi = c("https://10.1234/abc", "https://10.1234/def", "")
)
insert_reference("score1")
}
\keyword{internal}
