% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acep_men.R
\name{acep_men}
\alias{acep_men}
\title{Frecuencia de menciones de palabras.}
\usage{
acep_men(x, y, tolower = TRUE)
}
\arguments{
\item{x}{vector de textos al que se le aplica la funcion de conteo
de la frecuencia de menciones de palabras del diccionario.}

\item{y}{vector de palabras del diccionario utilizado.}

\item{tolower}{convierte los textos a minusculas.}
}
\value{
Si todas las entradas son correctas,
la salida sera un vector con una frecuencia
de palabras de un diccionario.
}
\description{
Funcion que cuenta la frecuencia de menciones de
palabras que refieren a conflictos en cada una de las notas/textos.
}
\examples{
df <- data.frame(texto = c("El SUTEBA fue al paro. Reclaman mejoras salariales.",
"El SOIP lleva adelante un plan de lucha con paros y piquetes."))
diccionario <- c("paro", "lucha", "piquetes")
df$detect <- acep_men(df$texto, diccionario)
df
}
\keyword{indicadores}
