% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsACV.R
\name{tsACV}
\alias{tsACV}
\title{Perform time-series cross-validation}
\usage{
tsACV(
  y,
  algorithm,
  m,
  h = 1,
  v = 1,
  xreg = NULL,
  lossFunction = function(y, yhat) {     (y - yhat)^2 },
  ...
)
}
\arguments{
\item{y}{Univariate time-series object.}

\item{algorithm}{Algorithm which is to be applied to the time-series. The object which the algorithm produces should respond to \code{fitted} and \code{forecast} methods.
Alternatively in the case of more complex custom algorithms, the algorithm may be a function which takes named arguments \verb{("yInSample", "yOutSample", "h")} or \verb{("yInSample", "yOutSample", "h", "xregInSample", "xregOutSample")} as inputs and produces a list with named elements \verb{("yhatInSample", "yhatOutSample")} containing vectors of in-sample and out-of-sample forecasts.}

\item{m}{Length of the window on which the algorithm should be trained.}

\item{h}{Number of predictions made after a single training of the algorithm.}

\item{v}{Number of periods by which the estimation window progresses forward once the predictions are generated.}

\item{xreg}{Matrix of exogenous regressors supplied to the algorithm (if applicable).}

\item{lossFunction}{Loss function used to compute contrasts (defaults to squared error).}

\item{...}{Other parameters passed to the algorithm.}
}
\value{
Matrix of computed contrasts \code{Phi}. Each row corresponds to a particular period of the \code{y} time-series and each column corresponds to a particular location of the training window.
}
\description{
Function \code{tsACV()} computes contrasts between forecasts produced by a given algorithm and the original time-series on which the algorithm is trained.
This can then be used to estimate the loss of the algorithm.
Unlike the similar \code{tsCV()} function from the \code{'forecast'} package, \code{tsACV()} also records in-sample contrasts as these can be leveraged to produce more accurate out-of-sample loss estimates.
}
\examples{
set.seed(1)
y <- rnorm(40)
m <- 36
h <- 1
v <- 1
tsACV(y, forecast::Arima, m = m, h = h, v = v)

}
