% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BID.R
\name{BioInfo.Power}
\alias{BioInfo.Power}
\title{Power calculation for Biomarker-Informed Design with Hierarchical Model}
\usage{
BioInfo.Power(uCtl, u0y, u0x, rhou, suy, sux, rho, sy, sx, Zalpha, N1, N, nArms, nSims)
}
\arguments{
\item{uCtl}{mean value for the control group.}

\item{u0y}{mean parameter of the group 1 for the parent model.}

\item{u0x}{mean parameter  of the group 2 for the parent model.}

\item{rhou}{correlation coefficient between two groups for the parent model.}

\item{suy}{standard deviation of the group 1 for the parent model.}

\item{sux}{standard deviation of the group 2 for the parent model.}

\item{rho}{correlation coefficient between two groups for the lower level model.}

\item{sy}{standard deviation of the group 1 for the lower level model.}

\item{sx}{standard deviation of the group 2 for the lower level model.}

\item{Zalpha}{crtical point for rejection.}

\item{N1}{sample size per group at interim analysis.}

\item{N}{sample size per group at final analysis.}

\item{nArms}{number of active groups.}

\item{nSims}{number of simulation times.}
}
\value{
The evaluated power and probability of selecting the arm as the winner.
}
\description{
Given the Biomarker-Informed design information, returns the overall power and probability of the arm is selected as the winner.
}
\examples{
## Determine critical value Zalpha for alpha (power) =0.025
u0y=c(0,0,0); u0x=c(0,0,0)
BioInfo.Power(uCtl=0, u0y, u0x, rhou=1, suy=0, sux=0, rho=1, sy=4, sx=4,
 Zalpha=2.772, N1=100, N=300, nArms=3, nSims=1000)
## Power simulation
u0y=c(1,0.5,0.2)
u0x=c(2,1,0.5)
BioInfo.Power(uCtl=0, u0y, u0x, rhou=0.2, suy=0.2, sux=0.2, rho=0.2, sy=4, sx=4,
 Zalpha=2.772, N1=100, N=300, nArms=3, nSims=500)

}
\author{
Yalin Zhu
}
\references{
Chang, M. (2014). Adaptive design theory and implementation using SAS and R.
\emph{CRC Press}.
}

