% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.adpclust.R
\name{plot.adpclust}
\alias{plot.adpclust}
\title{Visualize the result of adpclust()}
\usage{
\method{plot}{adpclust}(x, cols = "default", to.plot = c("cluster.sil",
  "fd"), ...)
}
\arguments{
\item{x}{an object of class "adpclust". Result of adpclust().}

\item{cols}{vector of colors used to distinguish different clusters. Recycled if necessary.}

\item{to.plot}{string vector that indicate which plot(s) to show. The two options are 'cluster.sil' (nclust vs. silhouette) and 'fd' (f vs. delta).}

\item{...}{Not used.}
}
\description{
Plot the f vs. delta plot with selected centroids.
}
\examples{
## Load a data set with 3 clusters
data(clust3)
## Automatically select cluster centroids
ans <- adpclust(clust3, centroids = "auto")
plot(ans)
plot(ans, to.plot = "fd")
plot(ans, to.plot = "cluster.sil")
plot(ans, to.plot = c("cluster.sil", "fd")) #Default
}

