% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{anisotropic_bm_particle_intensity}
\alias{anisotropic_bm_particle_intensity}
\title{Simulate 2D particle trajectory follows anisotropic Brownian Motion}
\usage{
anisotropic_bm_particle_intensity(pos0, M, len_t, sigma)
}
\arguments{
\item{pos0}{initial position for \code{M} particles, matrix with dimension M by 2}

\item{M}{number of particles}

\item{len_t}{number of time steps}

\item{sigma}{distance moved per time step in x,y-directions, a vector of length 2}
}
\value{
Position matrix with dimension \code{M}\eqn{\times}{\%\times}\code{len_t}
by 2 for particle trajectory. The first \code{M} rows being the initial position
\code{pos0}.
}
\description{
Simulate 2D particle trajectory follows anisotropic Brownian Motion (BM) for
\code{M} particles, with different step sizes in x, y-directions.
}
\examples{
library(AIUQ)
M = 10
len_t = 50
sigma = c(0.5,0.1)
pos0 = matrix(100/8+0.75*100*runif(M*2),nrow=M,ncol=2)
pos = anisotropic_bm_particle_intensity(pos0=pos0,M=M,len_t=len_t,sigma=sigma)
}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
