% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\docType{data}
\name{chapter_11_table_20}
\alias{chapter_11_table_20}
\alias{C11T20}
\alias{Chapter_11_Table_20}
\alias{c11t20}
\title{The data used in Chapter 11, Table 20}
\format{
An object of class \code{data.frame} with 15 rows and 3 columns.
}
\source{
\url{https://designingexperiments.com/data/}

Maxwell, S. E., Delaney, H. D., & Kelley, K. (2018). \emph{Designing experiments and
analyzing data: {A} model comparison perspective}. (3rd ed.). New York, NY: Routledge.
}
\usage{
data(chapter_11_table_20)
}
\description{
The data used in Chapter 11, Table 20
}
\details{
Table 11.20 shows hypothetical data obtained from three judges, each of whom has rated five targets (i.e., subjects). This data will be important in determining if our reliability measure should reflect consistency or agreement. Notice that the rank order of targets is identical for each of the three judges (in fact, not only are the ranks identical, but the scores are also perfectly linearly related to one another in this example). However, in an absolute sense, the ratings provided by Judge 2 are clearly very different from the ratings of the other two judges... Consistency is relatively low in these data, because the columns of scores do not closely resemble one another. However, agreement is high in these data because the relative position of any target in the distribution of scores is identical for each and every judge.

The analysis of the data contained in Table 11.20 is carried out in exactly the same manner as was the data contained in Table 11.19. Thus, a mixed effects ANOVA model is performed in order to obtain the mean squares which are then used in the formulas give towards the end of Chapter 11.
}
\section{Variables}{

\describe{
\item{months30}{age-normed general cognitive score for 30-month-old}
\item{months36}{age-normed general cognitive score for 36-month-old}
\item{months42}{age-normed general cognitive score for 42-month-old}
\item{months48}{age-normed general cognitive score for 48-month-old}
}
}

\section{Synonym}{

C11T20
}

\examples{
# Load the data
data(chapter_11_table_20)

# Or, alternatively load the data as
data(C11T20)

# View the structure
str(chapter_11_table_20)

}
\references{
Maxwell, S. E., Delaney, H. D., & Kelley, K. (2018). \emph{Designing experiments and analyzing data:
{A} model comparison perspective} (3rd ed.). New York, NY: Routledge.
}
\author{
Ken Kelley \email{kkelley@nd.edu}
}
\keyword{datasets}
