% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\docType{data}
\name{chapter_14_table_8}
\alias{chapter_14_table_8}
\alias{C14T8}
\alias{Chapter_14_Table_8}
\alias{c14t8}
\title{The data used in Chapter 14, Table 8}
\format{
An object of class \code{data.frame} with 20 rows and 3 columns.
}
\source{
\url{https://designingexperiments.com/data/}

Maxwell, S. E., Delaney, H. D., & Kelley, K. (2018). \emph{Designing experiments and
analyzing data: {A} model comparison perspective}. (3rd ed.). New York, NY: Routledge.
}
\usage{
data(chapter_14_table_8)
}
\description{
The data used in Chapter 14, Table 8
}
\details{
For the hypothetical data contained in Table 14.8, a perceptual psychologist is interested in age differences ("young" and "old") in reaction time on a perceptual task. In addition, the psychologist is also interested in the effect of angle (zero degrees off center and eight degrees off center). The question of interest is to see if there are is a main effect of age, a main effect of angle, and an interaction between the two. Table 14.8 presents the same data that we analyzed in chapter 12 for 10 young participants and 10 old participants, except that for the moment we are only analyzing data from the 0 degree and 8 degree conditions of the angle factor.

In any two factor design, the effects to be tested are typically the two main effects and the two-way interaction. In our example, then, we test the main effect of age (designated A), the main effect of angle (designated B), and the interaction of age and angle.
}
\section{Variables}{

\describe{
\item{angle0}{participant reaction time at angle 0}
\item{angle8}{participant reaction time at angle 8}
\item{group}{participant age (young or old)}
}
}

\section{Synonym}{

C14T8
}

\examples{
# Load the data
data(chapter_14_table_8)

# Or, alternatively load the data as
data(C14T8)

# View the structure
str(chapter_14_table_8)

}
\references{
Maxwell, S. E., Delaney, H. D., & Kelley, K. (2018). \emph{Designing experiments and analyzing data:
{A} model comparison perspective} (3rd ed.). New York, NY: Routledge.
}
\author{
Ken Kelley \email{kkelley@nd.edu}
}
\keyword{datasets}
