% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_edd_situation.R
\name{calc_edd_situation}
\alias{calc_edd_situation}
\title{Calculate Everyday Discrimination Situation Score}
\usage{
calc_edd_situation(survey_df, reason)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}

\item{reason}{An optional argument specifying the reason for perceived discrimination, e.g., race or age.
If provided, the function will limit the analysis to participants who reported this reason.}
}
\value{
A data frame with two columns: `person_id` and `edd_situation`, where `edd_situation`
is the calculated situation score for each participant. Participants who did not answer all 9 questions
or did not specify the given reason (if provided) will have an NA score.
}
\description{
This function computes a situation score indicating how many specific questions participants responded to with
something other than 'Never'. The score ranges from 0 to 9, with higher scores indicating more frequent perceived
experiences of unfair treatment. The function also allows for filtering by a specific reason for discrimination.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = rep(1:3, each = 9),
  question_concept_id = rep(c(40192380, 40192395, 40192416, 40192451, 40192466,
                              40192489, 40192490, 40192496, 40192519), times = 3),
  answer_concept_id = sample(c(40192465, 40192464, 40192453, 40192461, 40192391,
                               40192421), 27, replace = TRUE)
)

# Compute everyday discrimination situation scores
edd_situation_scores <- calc_edd_situation(survey_df)
head(edd_situation_scores)

}
