% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.ATbounds.R
\name{summary.ATbounds}
\alias{summary.ATbounds}
\title{Summary method for ATbounds objects}
\usage{
\method{summary}{ATbounds}(object, ...)
}
\arguments{
\item{object}{ATbounds object}

\item{...}{Additional arguments for summary generic}
}
\value{
A summary is produced with bounds estimates and confidence intervals.
In addition, it has the following elements.
\item{Lower_Bound}{lower bound estimate and lower end point of the confidence interval}
\item{Upper_Bound}{upper bound estimate and upper end point of the confidence interval}
}
\description{
Produce a summary for an ATbounds object.
}
\examples{
  Y <- RHC[,"survival"]
  D <- RHC[,"RHC"]
  X <- RHC[,c("age","edu")]
  rps <- rep(mean(D),length(D))
  results_ate <- atebounds(Y, D, X, rps, Q = 3)
  summary(results_ate)

}
\references{
Sokbae Lee and Martin Weidner. Bounding Treatment Effects by Pooling Limited Information across Observations.
}
