% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.R
\name{simulate_stream}
\alias{simulate_stream}
\title{Simulate Process Monitoring Data for Stream-Based Active Learning}
\usage{
simulate_stream(
  d = 10,
  TT = 500,
  T0 = 100,
  T_min_IC = 60,
  T_max_IC = 85,
  T_OC = 5,
  mean = NULL,
  covariance = NULL
)
}
\arguments{
\item{d}{Integer. Number of variables (dimension of the multivariate
observations). Default is 10.}

\item{TT}{Integer. Length of the sequence after the initial IC portion.
Default is 500.}

\item{T0}{Integer. Length of the initial IC sequence known to belong to
state 1. Default is 100.}

\item{T_min_IC, T_max_IC}{Integers. Minimum and maximum length of consecutive IC
observations before switching to an OC state.}

\item{T_OC}{Integer. Fixed length of each OC state sequence.}

\item{mean}{List of three numeric vectors of length \code{d}, representing
the mean vectors of states 1 (IC), 2 (OC), and 3 (OC). If \code{NULL}
(default), simple default values are used.}

\item{covariance}{List of three \code{d x d} covariance matrices, one for each
state. If \code{NULL} (default), pre-defined (equal) covariance matrices are used.}
}
\value{
A list with elements:
  \item{x}{Integer vector of latent states of length \code{T0 + TT}.}
  \item{y}{Matrix of simulated multivariate observations with \code{T0 + TT}
    rows and \code{d} columns.}
}
\description{
Generate a sequence of latent states and corresponding multivariate Gaussian
observations for process monitoring. The process has three possible states:
\enumerate{
  \item state 1: in-control (IC),
  \item state 2: out-of-control (OC),
  \item state 3: out-of-control (OC).
}
}
\details{
The first \code{T0} observations are fixed in state 1 (IC). Then, in the
following \code{TT} observations, only state 2 appears in the first half, and
only state 3 appears in the second half. Within each half, runs of state 1
(IC) of random length between \code{T_min_IC} and \code{T_max_IC} alternate
with fixed-length runs of the corresponding OC state of length \code{T_OC}.
}
\examples{
library(ActiveLearning4SPM)
sim <- simulate_stream()
table(sim$x)

}
