% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReadGT3XPlus.r
\name{ReadGT3XPlus}
\alias{ReadGT3XPlus}
\title{Read the raw tri-axial accelerometry data csv file by ActiGraph GT3X+.}
\usage{
ReadGT3XPlus(filename, epoch = 1)
}
\arguments{
\item{filename}{The name of the csv file.}

\item{epoch}{The epoch length (in second) of the Activity Index. Must
be a positive integer. The default is \code{1}.}
}
\value{
The \code{ReadGT3XPlus} returns an object of \link{class} "\code{GT3XPlus}".
This class of object is supported by functions \code{\link{computeActivityIndex}}.
A object of class "\code{GT3XPlus}" is a list containing at least the following components:

 \code{SN}: Serial Number of the accelerometer

 \code{StartTime}: Start time of the data collection

 \code{StartDate}: Start date of the data collection

 \code{Epoch}: The Epoch time of each observation. If sample rate \code{Hertz}>1, then \code{Epoch}=00:00:00

 \code{DownloadTime}: Download time of the data

 \code{DownloadDate}: Download date the data

 \code{Hertz}: Sampling Rate

 \code{Raw}: a data frame with 5 columns containing the date, time and acceleration in X, Y and Z axes
for each observation.
}
\description{
\code{ReadGT3XPlus} reads the accelerometry data collected by ActiGraph GT3XPlus
in csv files generated by ActiLife software. It automatically parses the header
of the csv file to acquire the setting of the device.
}
\details{
The function is tested on the csv files generated by ActiLife6, which have exactly
10 lines of headers, containing information about the device name, the starting
and ending date/time of data collection, the sample rate, and the downloading date/time,
etc. The 11th may further be omitted, if it is the header for the tri-axial acceleration
time series. The function only reads the first 3 columns from then, if more are present.
}
\examples{
filename = system.file("extdata","sample_GT3X+.csv.gz",package="ActivityIndex")
res = ReadGT3XPlus(filename)

}
