% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeActivityIndex.r
\name{computeActivityIndex}
\alias{computeActivityIndex}
\alias{computeActivityIndex.default}
\alias{computeActivityIndex.GT3XPlus}
\title{Compute Activity Index}
\usage{
computeActivityIndex(x, x_sigma0 = NULL, sigma0 = NULL, epoch = 1, hertz)

\method{computeActivityIndex}{default}(x, x_sigma0 = NULL, sigma0 = NULL, epoch = 1, hertz)

\method{computeActivityIndex}{GT3XPlus}(x, x_sigma0 = NULL, sigma0 = NULL, epoch = 1, hertz)
}
\arguments{
\item{x}{An object containing raw accelerometry data, which could
either be a 4-column data frame or "\code{GT3XPlus}" object. See "Details".}

\item{x_sigma0}{A 4-column data frame containing the raw accelerometry
data when the device is not worn. The 1st column has the record/index
number. The 2nd to 4th columns contain the tri-axial raw acceleration. The
data will be used to calculate \eqn{\bar{\sigma}_i}.}

\item{sigma0}{Specify \eqn{\bar{\sigma}_i} directly. At least one of
\code{x_sigma0} and \code{sigma0} must be specified. If both existed,
\code{sigma0} will be used.}

\item{epoch}{The epoch length (in second) of the Activity Index. Must
be a positive integer.}

\item{hertz}{The sample rate of the data.}
}
\value{
A data frame with two columns. The first column has the "record
number" associated with each entry of Activity Index, while the second column
 has the actual value of Activity Index.
}
\description{
\code{computeActivityIndex} computes the Activity Index using raw
accelerometry data, based on user specified parameters such as sample rate
and epoch length.
}
\details{
\code{x} could be either of the following two types of objects:
\enumerate{
   \item A 4-column data frame containing the tri-axial raw accelerometry
   data in the 2nd to 4th column, and the associated record number (could be
   time) in the 1st column. \code{\link{ReadTable}} can be used to generate
   such data frame.
   \item An "\code{GT3XPlus}" object given by function
   \code{\link{ReadGT3XPlus}}.
   }
}
\examples{
library(graphics)
fname = system.file("extdata", "sample_table.csv.gz",
package = "ActivityIndex")
sampleTable = ReadTable(fname)
AI_sampleTable_x = computeActivityIndex(
  sampleTable,
  x_sigma0 = sampleTable[1004700:1005600, ],
  epoch = 1,
  hertz = 30)
AI_sampleTable_x
plot(AI ~ RecordNo, data = AI_sampleTable_x, type = "l")
}
