% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Isotherms.R
\name{freundlich_model}
\alias{freundlich_model}
\title{Freundlich Isotherm Model}
\usage{
freundlich_model(Ce, Qe)
}
\arguments{
  \item{Ce}{Numeric vector of equilibrium concentrations.}

  \item{Qe}{Numeric vector of amount adsorbed.}
}
\value{
A named list of Freundlich parameters and model details.
}
\description{
The Freundlich isotherm describes adsorption on heterogeneous surfaces and assumes that stronger binding
sites are occupied first (Freundlich, 1907). The model is empirical and is expressed by the equation:

\deqn{Q = K_f \cdot C_e^{1/n}}

where \eqn{Q} is the amount adsorbed, \eqn{C_e} is the equilibrium concentration,
\eqn{K_f} is the Freundlich constant related to adsorption capacity, and \eqn{n} is the heterogeneity factor
(indicating adsorption intensity).

For more information, see Freundlich (1907): \doi{https://doi.org/10.1002/ange.19070201805}
}
\examples{
Ce <- c(1, 2, 3, 4, 5)
Qe <- c(0.8, 1.5, 2.1, 2.6, 2.9)
result <- freundlich_model(Ce, Qe)
print(result[1:2])
print(result$`Model Summary`)
print(result$Plot)
}
\seealso{
Other linear models: \code{\link{bet_model}()}, \code{\link{langmuir_model}()}, \code{\link{temkin_model}()}
}
