% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Isotherms.R
\name{nonlinear_bet}
\alias{nonlinear_bet}
\title{Non-linear BET Model}
\usage{
nonlinear_bet(Ce, Qe, Cs = max(Ce) * 1.1)
}
\arguments{
  \item{Ce}{Numeric vector of equilibrium concentrations.}

  \item{Qe}{Numeric vector of amount adsorbed.}

  \item{Cs}{Saturation concentration (default is 110\% of the maximum equilibrium concentration).}
}
\value{
A named list of BET parameters and model details, including estimated parameters, model statistics, and a diagnostic plot.
}
\description{
The non-linear BET isotherm extends the Langmuir model to multilayer adsorption and is used to evaluate
surface area and porosity of adsorbents. It fits the model directly using non-linear least squares estimation.

The BET equation is expressed as:

\deqn{Q = \frac{Q_m \cdot C_b \cdot C_e}{(C_s - C_e) \left(1 + (C_b - 1) \cdot \frac{C_e}{C_s} \right)}}

where \eqn{Q} is the amount adsorbed, \eqn{C_e} is the equilibrium concentration,
\eqn{C_s} is the saturation concentration, \eqn{Q_m} is the monolayer adsorption capacity,
and \eqn{C_b} is the BET constant.

The model uses non-linear regression to estimate parameters.
}
\examples{
Ce <- c(1, 2.5, 4, 5.5, 7)
Qe <- c(0.4, 1.0, 1.7, 2.3, 2.7)
result <- nonlinear_bet(Ce, Qe)
print(result$`BET Qm (mg/g)`)
print(result$`BET Cb`)
print(result$AIC)
print(result$`Pseudo R2`)
print(result$Plot)
}
\seealso{
Other nonlinear models: \code{\link{nonlinear_freundlich}()}, \code{\link{nonlinear_langmuir}()}, \code{\link{nonlinear_temkin}()}
}
\concept{nonlinear}
