% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplot_positive_function.R
\name{barplot_positive}
\alias{barplot_positive}
\title{Graph: Positive barplot}
\usage{
barplot_positive(
  a,
  b,
  ylab = "Response",
  var_name = c("Var1", "Var2"),
  legend.title = "Variable",
  fill_color = c("darkgreen", "brown"),
  width.col = 0.9,
  width.bar = 0.2
)
}
\arguments{
\item{a}{Object of DIC, DBC or DQL functions}

\item{b}{Object of DIC, DBC or DQL functions}

\item{ylab}{Y axis names (this argument uses the \emph{parse} function)}

\item{var_name}{Name of the variable}

\item{legend.title}{Legend title}

\item{fill_color}{Bar fill color}

\item{width.col}{Width Column}

\item{width.bar}{Width error bar}
}
\value{
The function returns a column chart with two positive sides
}
\description{
Column chart with two variables that assume a positive response and represented by opposite sides, such as dry mass of the area and dry mass of the root
}
\note{
When there is only an effect of the isolated factor in the case of factorial or subdivided plots, it is possible to use the barplot_positive function.
}
\examples{
data("passiflora")
attach(passiflora)
a=with(passiflora, DBC(trat, bloco, MSPA))
b=with(passiflora, DBC(trat, bloco, MSR))
barplot_positive(a, b, var_name = c("DMAP","DRM"), ylab = "Dry root (g)")

a=with(passiflora, DIC(trat, MSPA,test = "noparametric"))
b=with(passiflora, DIC(trat, MSR))
barplot_positive(a, b, var_name = c("DMAP","DRM"), ylab = "Dry root (g)")
}
\seealso{
\link{sk_graph}, \link{plot_TH}, \link{corgraph}, \link{spider_graph}, \link{line_plot}
}
\author{
Gabriel Danilo Shimizu, \email{gabrield.shimizu@gmail.com}
}
