% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMetrics.R
\name{all_metrics}
\alias{all_metrics}
\title{Calculating Multiple Performance Metrics of a Prediction Model}
\usage{
all_metrics(actual, predicted)
}
\arguments{
\item{actual}{This is the actual time series values}

\item{predicted}{This is the predicted values of a time series using a model}
}
\value{
\itemize{
  \item AllMetrics - A data frame containing two columns with first column as the name of the eight metrics and second column as the corresponding values
}
}
\description{
This provides a function to calculate multiple performance metrics for actual and predicted values.
}
\examples{
actual <- c(1.5, 2.3, 25, 52, 14)
predicted <- c(1.2, 10, 3.5, 4.3, 5.6)
# Inside the function 1st specify actual then predicted
print(all_metrics(actual, predicted))
}
\references{
\itemize{
\item Garai, S., & Paul, R. K. (2023). Development of MCS based-ensemble models using CEEMDAN decomposition and machine intelligence. Intelligent Systems with Applications, 18, 200202.
\item Garai, S., Paul, R. K., Kumar, M., & Choudhury, A. (2023). Intra-annual National Statistical Accounts Based on Machine Learning Algorithm. Journal of Data Science and Intelligent Systems. https://doi.org/10.47852/bonviewJDSIS3202870
\item Garai, S., Paul, R.K., Yeasin, M., Paul, A.K. (2024). CEEMDAN-Based Hybrid Machine Learning Models for Time Series Forecasting Using MARS Algorithm and PSO-Optimization. Neural Processing Letters, 56, 92. https://doi.org/10.1007/s11063-024-11552-w
}
}
