% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{MLEAFT}
\alias{MLEAFT}
\title{Accelerated Failure Time (AFT) Model.}
\usage{
MLEAFT(
  init,
  times,
  status,
  n,
  basehaz,
  z,
  method = "BFGS",
  hessian = TRUE,
  conf.int = 0.95,
  maxit = 1000,
  log = FALSE
)
}
\arguments{
\item{init}{: initial points for optimisation}

\item{times}{: survival times}

\item{status}{: vital status (1 - dead, 0 - alive)}

\item{n}{: The number of the data set}

\item{basehaz}{: baseline hazard structure including baseline (New generalized log-logistic accelerated failure time "NGLLAFT" model,  generalized log-logisitic accelerated failure time "GLLAFT" model, modified log-logistic accelerated failure time "MLLAFT" model,
exponentiated Weibull accelerated failure time "EWAFT" model, power generalized weibull accelerated failure time "PGWAFT" model, generalized gamma accelerated failure time "GGAFT" model,
modified kumaraswamy Weibull proportional odds "MKWAFT" model, log-logistic accelerated failure time "LLAFT" model,
tangent-log-logistic accelerated failure time "TLLAFT" model, sine-log-logistic accelerated failure time "SLLAFT" model, cosine log-logistic accelerated failure time "CLLAFT" model,
secant-log-logistic accelerated failure time "SCLLAFT" model, arcsine-log-logistic accelerated failure time "ASLLAFT" model, arctangent-log-logistic accelerated failure time "ATLLAFT" model,
Weibull accelerated failure time "WAFT" model, gamma accelerated failure time "GAFT", and log-normal accelerated failure time "LNAFT")}

\item{z}{: design matrix for covariates (p x n), p >= 1}

\item{method}{:"optim" or a method from "nlminb".The methods supported are: BFGS (default), "L-BFGS", "Nelder-Mead", "SANN", "CG", and "Brent".}

\item{hessian}{:A function to return (as a matrix) the hessian for those methods that can use this information.}

\item{conf.int}{: confidence level}

\item{maxit}{:The maximum number of iterations. Defaults to 1000}

\item{log}{:log scale (TRUE or FALSE)}
}
\value{
a list containing the output of the optimisation (OPT) and the log-likelihood function (loglik)
}
\description{
Tractable Parametric accelerated failure time (AFT) model's maximum likelihood estimation, log-likelihood, and information criterion.
 Baseline hazards: NGLL,GLL,MLL,PGW, GG, EW, MKW, LL, TLL, SLL,CLL,SCLL,ATLL, and ASLL
}
\examples{

#Example #1
data(alloauto)
time<-alloauto$time
delta<-alloauto$delta
z<-alloauto$type
MLEAFT(init = c(1.0,0.20,0.05),times = time,status = delta,n=nrow(z),
basehaz = "WAFT",z = z,method = "BFGS",hessian=TRUE, conf.int=0.95,maxit = 1000,
log=FALSE)

#Example #2
data(bmt)
time<-bmt$Time
delta<-bmt$Status
z<-bmt$TRT
MLEAFT(init = c(1.0,1.0,0.5),times = time,status = delta,n=nrow(z),
basehaz = "LNAFT",z = z,method = "BFGS",hessian=TRUE, conf.int=0.95,maxit = 1000,log=FALSE)

#Example #3
data("gastric")
time<-gastric$time
delta<-gastric$status
z<-gastric$trt
MLEAFT(init = c(1.0,0.50,0.5),times = time,status = delta,n=nrow(z),
basehaz = "LLAFT",z = z,method = "BFGS",hessian=TRUE, conf.int=0.95,maxit = 1000,
log=FALSE)

#Example #4
data("larynx")
time<-larynx$time
delta<-larynx$delta
larynx$age<-as.numeric(scale(larynx$age))
larynx$diagyr<-as.numeric(scale(larynx$diagyr))
larynx$stage<-as.factor(larynx$stage)
z<-model.matrix(~ stage+age+diagyr, data = larynx)
MLEAFT(init = c(1.0,0.5,0.5,0.5,0.5,0.5,0.5,0.5),times = time,status = delta,n=nrow(z),
basehaz = "LNAFT",z = z,method = "BFGS",hessian=TRUE, conf.int=0.95,maxit = 1000,
log=FALSE)

}
\author{
Abdisalam Hassan Muse, Samuel Mwalili, Oscar Ngesa, Christophe Chesneau  \email{abdisalam.hassan@amoud.edu.so}
}
