% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomeObject.R
\name{getCAIweights}
\alias{getCAIweights}
\title{Calculate the CAI codon weigths for a reference genome}
\usage{
getCAIweights(referenceGenome, default.weight = 0.5)
}
\arguments{
\item{referenceGenome}{A genome object initialized with \code{\link{initializeGenomeObject}}.}

\item{default.weight}{Set default weight for any codon not observed in the reference genome}
}
\value{
Returns a named vector with the CAI weights for each codon
}
\description{
\code{getCAIweights} returns the weights for the Codon Adaptation Index
based on a reference genome.
}
\examples{

genome_file <- system.file("extdata", "genome.fasta", package = "AnaCoDa")

## reading genome
referenceGenome <- initializeGenomeObject(file = genome_file)

wi <- getCAIweights(referenceGenome)

}
