% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R_AMids_distanceToArithmeticMedoids_SingleMedoids.R
\name{calculateAMidsArith}
\alias{calculateAMidsArith}
\title{Calculate genetic distances.}
\usage{
calculateAMidsArith(pathTotpeds, pathToAriMedoids, AMmcapply = F, nrcores,
  seqchip = "", noseqdat = F, wd, NameOut = NULL, pathAll00)
}
\arguments{
\item{pathTotpeds}{Character vector giving path to folder containing the plink tPED file(s) to be used.}

\item{pathToAriMedoids}{Character vector giving path to folder containing the arithmetic references to be used.}

\item{AMmcapply}{Logical value (TRUE or FALSE), specifying if the multicore funcion mcapply, should be used.
Inappropriate for most HPC cluster systems. Default = FALSE}

\item{nrcores}{Numeric value detailing how many cores should be used if AMmcapply==TRUE.
If left unspecificed the number of cores will be detected and nrcores will be set to that number -2.}

\item{seqchip}{Character vector specifying if only references from one main SNP chip panel are to be used. All references are marked with what chip panel they use at the end of their file names, eg 'Yoruba.HGDP.20000.Illumina.ods'
May be important if your data has few SNPs in common with one panel. All toy references prepared use 'Illumina' panels. Whole Genome sequence data is specified with 'WG'.
Supports custom designations, but will trigger a warning when used.}

\item{noseqdat}{Logical value (TRUE or FALSE), specifying if sequence data is to be excluded, will use only references that do not have names ending in '.WG.ods/rds/rda'. Default = FALSE}

\item{wd}{Character vector giving the desired working directory to house the outputs of calculateAMidsArith. If left unspecified will use current working directory.}

\item{NameOut}{Character vector giving the desired prefix name for the AMid file. Default is NULL.}

\item{pathAll00}{Character vector giving the path to a file containing the full data table of each dbSNP and both alleles. An example version covering the SNPs used in the example data is included. A full version can be found at: http://bit.ly/1OUstDP}
}
\description{
Calculates genetic distance between samples and population references.
}
\examples{
\dontrun{
Refs <- system.file('data', package = 'AncestryMapper')
tpeds <- system.file('extdata', package = 'AncestryMapper')
Corpheno <- system.file('extdata', 'CorPheno', package = 'AncestryMapper')
All00Frq <- system.file ('data', 'MinMaxFreq.rda', package = 'AncestryMapper')

genetic.distance <- calculateAMidsArith(pathTotpeds = tpeds,
                                   NameOut = 'Example',
                                   pathToAriMedoids = Refs,
                                   pathAll00 = All00Frq)

plotAMids(AMids = genetic.distance, phenoFile = Corpheno, columnPlot = "I")
}
}

