% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_length_summary.R
\name{count_distinct_elements_per_list_item_shuffled}
\alias{count_distinct_elements_per_list_item_shuffled}
\title{Count Distinct Elements per List Item in Shuffled Sequences}
\usage{
count_distinct_elements_per_list_item_shuffled(sequences, iterations = 100)
}
\arguments{
\item{sequences}{A list of character vectors, where each vector contains sequences of elements separated by spaces.}

\item{iterations}{An integer specifying the number of shuffling iterations.}
}
\value{
A numeric vector of length `iterations`, each element representing the number of distinct elements per list item in a shuffled sequence.
}
\description{
This function calculates the number of distinct elements per list item in a list of sequences shuffled using the 'shuffle_sequences_across' function. The shuffling is performed a specified number of times.
}
\examples{
sequences <- c('hello world', 'hello world hello', 'hello world hello world')
count_distinct_elements_per_list_item_shuffled(sequences, iterations = 100)
}
