% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/menzerath_plot.R
\name{menzerath_plot}
\alias{menzerath_plot}
\title{Create a Menzerath-Altmann Plot}
\usage{
menzerath_plot(sequences_long)
}
\arguments{
\item{sequences_long}{A data frame in long format. It should include columns for `sequence_nr`, `start_time`, and `end_time`. Each row represents an element in the sequence with its start and end times.}
}
\value{
A `ggplot` object. The plot shows the number of elements (x-axis) against the mean duration of sequences (y-axis) with a linear regression line.
}
\description{
This function generates a Menzerath-Altmann plot from a data frame in long format. The plot visualizes the relationship between the number of elements in sequences and the mean duration of these sequences.
}
\details{
The function calculates the duration of each element as the difference between `end_time` and `start_time`. It then groups the data by `sequence_nr` to compute the number of elements and the mean duration of each sequence. The resulting plot helps in understanding the relationship described by the Menzerath-Altmann law, which postulates that larger linguistic units tend to have shorter mean durations.
}
\examples{
# Sample data frame
sequences_long <- data.frame(
  sequence_nr = rep(1:5, each = 3),
  start_time = rep(1:3, times = 5),
  end_time = rep(2:4, times = 5)
)
menzerath_plot(sequences_long)
}
