% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindLongestSeq.R
\name{FindLongestSeq}
\alias{FindLongestSeq}
\title{Find the longest sequence for each species from a list of GenBank accession numbers.}
\usage{
FindLongestSeq(Accessions)
}
\arguments{
\item{Accessions}{A vector of GenBank accession numbers.}
}
\value{
A list of genbank accessions numbers for the longest sequence for each taxon in a list of accession numbers.
}
\description{
Find the longest sequence for each species from a list of GenBank accession numbers.
}
\details{
For a set of GenBank accession numbers, this will return the longest sequence for in the set for species.
}
\examples{
#a vector of 4 genbank accessions, there are two for each species.
genbank.accessions<-c("KP978059.1","KP978060.1","JX516105.1","JX516111.1")
\dontrun{
#returns the longest sequence respectively for the two species.
long.seq.result<-FindLongestSeq(genbank.accessions)
}
}
