% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distance_matrix_knn_algorithm.R
\name{distance_matrix_cortNorm}
\alias{distance_matrix_cortNorm}
\title{Normalized distance matrix from a pattern recognition distance}
\usage{
distance_matrix_cortNorm(k, unit)
}
\arguments{
\item{k}{The parameter $k$ controls the contribution of the sum of squares
comparison as a value-based metric and the $Cort$ quantity as a behavioral
metric; when $k=0$, then the distance is equal to the value-based metric,
on the other hand, when $k=6$ the distance is mainly determined by the value
of the temporal correlation $Cort$.}

\item{unit}{A matrix representing a multivariate time series where each
column is a univariate time series.}
}
\value{
a matrix with pairwise distances
}
\description{
pairwise distance matrix of a multivariate time series based on a value
(Coefficient of variation) and behavior (temporal correlation) measures
}
\examples{
X=matrix( rnorm(200), ncol=10  )
k=2
distance_matrix_cortNorm(k,X)
}
\seealso{
Guillermo Granados, and Idris Eckley. "Electricity Demand of Buildings Benchmarked via Regression Trees on Nearest Neighbors Anomaly Scores"
}
