% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distance_matrix_knn_algorithm.R
\name{distance_matrix_mvLWS}
\alias{distance_matrix_mvLWS}
\title{Pairwise distance matrix based on the multivariate locally wavelet partial
coherence}
\usage{
distance_matrix_mvLWS(unit)
}
\arguments{
\item{unit}{A matrix representing a multivariate time series where each
column is a univariate time series.}
}
\value{
a matrix with pairwise distances
}
\description{
Pairwise distance matrix based on the multivariate locally wavelet partial
coherence
}
\examples{
X=matrix( rnorm(2000), ncol=10  )
distance_matrix_mvLWS(unit=X)
}
\seealso{
Park, Timothy, Idris A. Eckley, and Hernando C. Ombao.
"Estimating Time-Evolving Partial Coherence Between Signals via Multivariate
Locally Stationary Wavelet Processes." IEEE Transactions on Signal
Processing 62, no. 20 (October 2014): 5240-50. \doi{10.1109/TSP.2014.2343937}
}
