% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArchaeoPhases-package.R
\docType{package}
\name{ArchaeoPhases-package}
\alias{ArchaeoPhases-package}
\alias{ArchaeoPhases}
\title{ArchaeoPhases: Post-Processing of Markov Chain Monte Carlo Simulations for Chronological Modelling}
\description{
Statistical analysis of archaeological dates and groups of dates. This package allows to post-process Markov Chain Monte Carlo (MCMC) simulations from 'ChronoModel' \url{https://chronomodel.com/}, 'Oxcal' \url{https://c14.arch.ox.ac.uk/oxcal.html} or 'BCal' \url{https://bcal.shef.ac.uk/}. It provides functions for the study of rhythms of the long term from the posterior distribution of a series of dates (tempo and activity plot). It also allows the estimation and visualization of time ranges from the posterior distribution of groups of dates (e.g. duration, transition and hiatus between successive phases) as described in Philippe and Vibet (2020) \doi{10.18637/jss.v093.c01}.
}
\details{
\tabular{ll}{
\strong{Version} \tab 2.0.1 \cr
\strong{License} \tab GPL-3 \cr
\strong{CRAN DOI} \tab \doi{10.32614/CRAN.package.ArchaeoPhases} \cr
\strong{Zenodo DOI} \tab \doi{10.5281/zenodo.8087121} \cr
\strong{JSS DOI} \tab \doi{10.18637/jss.v093.c01} \cr
}

Laboratoire de Mathématiques Jean Leray (UMR 6629)\cr
2, rue de la Houssinière\cr
BP 92208\cr
F-44322 Nantes Cedex 3\cr
France
}
\section{Package options}{

\pkg{ArchaeoPhases} uses the following \code{\link[=options]{options()}} to configure behaviour:
\itemize{
\item \code{ArchaeoPhases.grid}: a \code{\link{numeric}} value specifying the number of equally
spaced points at which densities are to be estimated (defaults to
\eqn{512}). Should be a power of \eqn{2}.
\item \code{ArchaeoPhases.precision}: an \code{\link{integer}} indicating the number of decimal
places (defaults to \eqn{0}).
\item \code{ArchaeoPhases.progress}: a \code{\link{logical}} scalar specifying if progress bars
should be displayed (defaults to \code{\link[=interactive]{interactive()}}).
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://ArchaeoStat.github.io/ArchaeoPhases/}
  \item \url{https://github.com/ArchaeoStat/ArchaeoPhases}
  \item Report bugs at \url{https://github.com/ArchaeoStat/ArchaeoPhases/issues}
}

}
\author{
\strong{Maintainer}: Anne Philippe \email{anne.philippe@univ-nantes.fr} (\href{https://orcid.org/0000-0002-5331-5087}{ORCID})

Authors:
\itemize{
  \item Marie-Anne Vibet (\href{https://orcid.org/0000-0003-4003-3141}{ORCID})
  \item Nicolas Frerebeau \email{nicolas.frerebeau@u-bordeaux-montaigne.fr} (\href{https://orcid.org/0000-0001-5759-4944}{ORCID})
}

Other contributors:
\itemize{
  \item Thomas S. Dye (\href{https://orcid.org/0000-0001-8116-782X}{ORCID}) [contributor]
  \item Nantes Université (\href{https://ror.org/03gnr7b55}{ROR}) [funder]
  \item Université Bordeaux Montaigne (\href{https://ror.org/03pbgwk21}{ROR}) [funder]
  \item CNRS (\href{https://ror.org/02feahw73}{ROR}) [funder]
}

}
\keyword{internal}
