% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/interpolate.R
\docType{methods}
\name{interpolate}
\alias{interpolate}
\alias{interpolate-method}
\alias{interpolate,numeric,numeric-method}
\alias{interpolate,EventsMCMC,missing-method}
\title{Interpolate Between Two Dates}
\usage{
interpolate(x, y, ...)

\S4method{interpolate}{numeric,numeric}(x, y)

\S4method{interpolate}{EventsMCMC,missing}(x, e1 = 1, e2 = 2)
}
\arguments{
\item{x}{A \code{\link{numeric}} vector giving the output of the MCMC algorithm for the
first parameter.}

\item{y}{A \code{\link{numeric}} vector giving the output of the MCMC algorithm for the
second parameter.}

\item{...}{Currently not used.}

\item{e1, e2}{An \code{\link{integer}} specifying.}
}
\description{
Interpolate Between Two Dates
}
\details{
For a given output of MCMC algorithm, this function interpolates between
to events \eqn{x} and \eqn{y} (assuming \eqn{x < y}).
}
\examples{
## Coerce to events
eve <- as_events(mcmc_events, calendar = CE(), iteration = 1)
eve <- eve[1:10000, ]

## Interpolate between two events
inter <- interpolate(eve, e1 = 2, e2 = 3)
plot(inter, level = 0.95, interval = "credible")
}
\seealso{
Other age-depth modeling tools: 
\code{\link{bury}()}
}
\author{
N. Frerebeau
}
\concept{age-depth modeling tools}
