% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cortools.R
\name{correlation-tools}
\alias{correlation-tools}
\alias{r2z}
\alias{z2r}
\alias{r2t}
\alias{r2p}
\alias{rconfint}
\alias{compcorr}
\title{Correlation tools}
\usage{
r2z(r)

z2r(z)

r2t(r, n)

r2p(r, n)

rconfint(r, n, alpha = 0.05)

compcorr(r1, r2, n1, n2)
}
\arguments{
\item{r, r1, r2}{a correlation value}

\item{z}{a Z-score}

\item{n, n1, n2}{sample sizes}

\item{alpha}{the significance level to use}
}
\description{
Helper functions to compute important statistics from correlation coefficients.
}
\section{Functions}{
\itemize{
\item \code{r2z()}: converts correlation coefficients to z-scores

\item \code{z2r()}: converts z-scores to correlation coefficients

\item \code{r2t()}: Converts correlation coefficients to t-scores

\item \code{r2p()}: Computes the two-sided p-value for a given correlation

\item \code{rconfint()}: Computes confidence intervals for a given correlation coefficient

\item \code{compcorr()}: computes the significance of the difference between two correlation coefficients

}}
\examples{
z <- r2z(.5)
r <- z2r(z)
t<-r2t(r,30)
r2p(r,30)
print(rconfint(r,30))
print(compcorr(.5,.7,20,20))
}
\seealso{
\link{cormean}, \link{multiple.cor}, \link{partial.cor}
}
