% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCompareGenos.R
\name{plotCompareGenos}
\alias{plotCompareGenos}
\title{Compare to genotype matrices}
\usage{
plotCompareGenos(genos_1 = "genotypes_1", genos_2 = "genotypes_2",
  markerToPlot = "all", individualsToPlot = "all", chromToPlot = "all",
  CompColors = c("#000000", "#E69F00"), textSize = 12,
  showMarkerNames = FALSE, showIndividualNames = FALSE)
}
\arguments{
\item{genos_1}{Output of readABHgenotypes}

\item{genos_2}{Output of readABHgenotypes. Note that both genos object need to
have identical numbers of marker x individuals.}

\item{markerToPlot}{A character vector of marker names which appear in the
plot. Defaults to all.}

\item{individualsToPlot}{A character vector of individual names which appear
in the plot. Defaults to all.}

\item{chromToPlot}{A character vector of chromosome names which appear in the
plot. Defaults to all.}

\item{CompColors}{A character vector of length 2 giving the color names or
values to use for differnt and identical markers.
Defaults to black and orange.}

\item{textSize}{The size of all text elements in the plot. Useful for making a
nice plot. Defaults to 12.}

\item{showMarkerNames}{Show the marker names along the x axis. This and
showIndividualnames are useful when you display only a few markers and
want them labeled. Defaults to FALSE.}

\item{showIndividualNames}{Show individual names along the y axis.}
}
\value{
A graphical comparison of genotypes.
}
\description{
Compare to genotype matrices
}
\examples{
\dontrun{plotCompareGenos(preImpGenotypes,postImpGenotypes)}
\dontrun{#for more examples see plotGenos()}
}

