% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Population.R
\name{Population}
\alias{Population}
\title{R6 class that represents a population}
\description{
A population is a collection of agents. There are two important tasks
for a population:
\enumerate{
\item to manage the agents in it
\item to define the contact patterns of the agents
}

The contact patterns are defined by objects of the Contact class that
are associated with the population. A population may have multiple
Contact objects, for example, one for random mixing, one for close
contacts represented by a contact network, and another for social
network.
}
\section{Super class}{
\code{ABM::R6Agent} -> \code{R6Population}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{size}}{The population size, an integer}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-R6Population-new}{\code{Population$new()}}
\item \href{#method-R6Population-addAgent}{\code{Population$addAgent()}}
\item \href{#method-R6Population-removeAgent}{\code{Population$removeAgent()}}
\item \href{#method-R6Population-addContact}{\code{Population$addContact()}}
\item \href{#method-R6Population-agent}{\code{Population$agent()}}
\item \href{#method-R6Population-setState}{\code{Population$setState()}}
\item \href{#method-R6Population-setStates}{\code{Population$setStates()}}
\item \href{#method-R6Population-clone}{\code{Population$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ABM" data-topic="R6Agent" data-id="leave"><a href='../../ABM/html/R6Agent.html#method-R6Agent-leave'><code>ABM::R6Agent$leave()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ABM" data-topic="R6Agent" data-id="match"><a href='../../ABM/html/R6Agent.html#method-R6Agent-match'><code>ABM::R6Agent$match()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ABM" data-topic="R6Agent" data-id="schedule"><a href='../../ABM/html/R6Agent.html#method-R6Agent-schedule'><code>ABM::R6Agent$schedule()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ABM" data-topic="R6Agent" data-id="setDeathTime"><a href='../../ABM/html/R6Agent.html#method-R6Agent-setDeathTime'><code>ABM::R6Agent$setDeathTime()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ABM" data-topic="R6Agent" data-id="unschedule"><a href='../../ABM/html/R6Agent.html#method-R6Agent-unschedule'><code>ABM::R6Agent$unschedule()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Population-new"></a>}}
\if{latex}{\out{\hypertarget{method-R6Population-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Population$new(population = 0, initializer = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{population}}{can be either an external pointer pointing to
a population object returned from newPopulation, or an integer
specifying the population size, or a list.}

\item{\code{initializer}}{a function or NULL}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If population is a number (the population size), then initializer
can be a function that take the index of an agent and return its initial
state.  If it is a list, the length is the population size, and each element
corresponds to the initial state of an agent (with the same index).
Add an agent
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Population-addAgent"></a>}}
\if{latex}{\out{\hypertarget{method-R6Population-addAgent}{}}}
\subsection{Method \code{addAgent()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Population$addAgent(agent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{agent}}{either an object of the R6 class Agent, or an external
pointer returned from newAgent.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The agent is scheduled in the population. If the population
is already added to a simulation, the agent will report its state
to the simulation.
remove an agent
}

\subsection{Returns}{
the object itself for chaining actions.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Population-removeAgent"></a>}}
\if{latex}{\out{\hypertarget{method-R6Population-removeAgent}{}}}
\subsection{Method \code{removeAgent()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Population$removeAgent(agent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{agent}}{either an object of the R6 class Agent, or an external
pointer returned from newAgent.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The agent is scheduled in the population. If the population
is already added to a simulation, the agent will report its state
to the simulation.
Add a contact pattern
}

\subsection{Returns}{
the object itself for chaining actions.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Population-addContact"></a>}}
\if{latex}{\out{\hypertarget{method-R6Population-addContact}{}}}
\subsection{Method \code{addContact()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Population$addContact(contact)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{contact}}{an external pointer pointing to a Contact object,
e.g., created from newRandomMixing.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If the contact has already been added, this call does nothing.
return a specific agent by index
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Population-agent"></a>}}
\if{latex}{\out{\hypertarget{method-R6Population-agent}{}}}
\subsection{Method \code{agent()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Population$agent(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{the index of the agent (starting from 1)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an external pointer pointing to the agent
set the state of a specific agent by index
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Population-setState"></a>}}
\if{latex}{\out{\hypertarget{method-R6Population-setState}{}}}
\subsection{Method \code{setState()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Population$setState(i, state)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{the index of the agent (starting from 1)}

\item{\code{state}}{a list holding the state to set}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the population object itself for chaining actions
Set the states for the agents
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Population-setStates"></a>}}
\if{latex}{\out{\hypertarget{method-R6Population-setStates}{}}}
\subsection{Method \code{setStates()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Population$setStates(states)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{states}}{either a list holding the states (one for each agent), or a
function}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If \code{states} is a function then it takes a single argument
\code{i}, specifying the index of the agent (starting from 1), and returns
a state.
}

\subsection{Returns}{
the population object itself for chaining actions
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Population-clone"></a>}}
\if{latex}{\out{\hypertarget{method-R6Population-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Population$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
