% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onlyDeconAlgorithms.R
\name{estCellPercent}
\alias{estCellPercent}
\title{Wrapper for deconvolution methods}
\usage{
estCellPercent(
  refExpr,
  geneExpr,
  preNormalize = TRUE,
  verbose = TRUE,
  method = "DCQ",
  ...
)
}
\arguments{
\item{refExpr}{a data frame representing immune cell expression profiles. Each row represents an expression of a gene, and each column represents a different immune cell type. colnames contains the name of each immune cell type and the rownames includes the genes' symbol. The names of each immune cell type and the symbol of each gene should be unique. Any gene with missing expression values must be excluded.}

\item{geneExpr}{a data frame representing RNA-seq or microarray gene-expression profiles of a given complex tissue. Each row represents an expression of a gene, and each column represents a different experimental sample. colnames contain the name of each sample and rownames includes the genes' symbol. The name of each individual sample and the symbol of each gene should be unique. Any gene with missing expression values should be excluded.}

\item{preNormalize}{Set to TRUE to quantile normalize geneExpr to match refExpr (DEFAULT: TRUE)}

\item{verbose}{Set to TRUE to echo the results of parameters (DEFAULT: TRUE)}

\item{method}{One of 'DCQ', 'SVMDECON', 'DeconRNASeq', 'proportionsInAdmixture', 'nnls' (DEFAULT: DCQ)}

\item{...}{Parameters for estCellPercent.X (e.g. number_of_repeats for .DCQ)}
}
\value{
A matrix with cell type estimates for each samples
}
\description{
A wrapper function to call any of the estCellPercent functions
   Modified on June 16th 2021 to quantile normalize the geneExpr data to match refExpr
   Set preNormalize to FALSE for previous behavior.
}
\examples{
#This toy example 
library(ADAPTS)
fullLM22 <- ADAPTS::LM22[1:30, 1:4]
smallLM22 <- fullLM22[1:25,] 

cellEst <- estCellPercent(refExpr=smallLM22, geneExpr=fullLM22, preNormalize=FALSE, verbose=TRUE)

}
