% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeSigMatrix.R
\name{splitSCdata}
\alias{splitSCdata}
\title{Split a single cell dataset into multiple sets}
\usage{
splitSCdata(
  RNAcounts,
  cellIDs = colnames(RNAcounts),
  numSets = 3,
  verbose = TRUE,
  randomize = TRUE
)
}
\arguments{
\item{RNAcounts}{The single cell matrix}

\item{cellIDs}{A vector will cell types for each column in scCountMatrix (DEFAULT: colnames(RNAcounts))}

\item{numSets}{The number of sets to break it up into (DEFAULT: 3)}

\item{verbose}{Set to TRUE to print cell counts as it goes (DEFAULT: TRUE)}

\item{randomize}{Set to TRUE to randomize the sets (DEFAULT: TRUE)}
}
\value{
a list with a multiple sets
}
\description{
Take a matrix of single cell data with genes as rows and each column corresponding
to a single cells. Break it up into rougly equal subsets, taking care to make sure that each cell type is represented
in each set if possible
}
\examples{
RNAcounts <- matrix(0, nrow=10, ncol=30)
rownames(RNAcounts) <- make.names(rep('Gene', nrow(RNAcounts)), unique=TRUE)
colnames(RNAcounts) <- make.names(c('CellX', rep('CellY', 9), 
rep('CellZ', 10), rep('CellB', 10)), unique=TRUE)
RNAcounts[, grepl('CellY', colnames(RNAcounts))] <- 1
RNAcounts[, grepl('CellZ', colnames(RNAcounts))] <- 2
RNAcounts[, grepl('CellB', colnames(RNAcounts))] <- 3
splitSCdata(RNAcounts, numSets=3)

}
