% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{CV_ADMMc}
\alias{CV_ADMMc}
\title{CV ADMM penalized precision matrix estimation (c++)}
\usage{
CV_ADMMc(X, S, lam, alpha, diagonal = FALSE, path = FALSE, rho = 2,
  mu = 10, tau_inc = 2, tau_dec = 2, crit = "ADMM", tol_abs = 1e-04,
  tol_rel = 1e-04, maxit = 10000L, adjmaxit = 10000L, K = 5L,
  crit_cv = "loglik", start = "warm", trace = "progress")
}
\arguments{
\item{X}{option to provide a nxp matrix. Each row corresponds to a single observation and each column contains n observations of a single feature/variable.}

\item{S}{option to provide a pxp sample covariance matrix (denominator n). If argument is \code{NULL} and \code{X} is provided instead then \code{S} will be computed automatically.}

\item{lam}{positive tuning parameters for elastic net penalty. If a vector of parameters is provided, they should be in increasing order.}

\item{alpha}{elastic net mixing parameter contained in [0, 1]. \code{0 = ridge, 1 = lasso}. If a vector of parameters is provided, they should be in increasing order.}

\item{diagonal}{option to penalize the diagonal elements of the estimated precision matrix (\eqn{\Omega}). Defaults to \code{FALSE}.}

\item{path}{option to return the regularization path. This option should be used with extreme care if the dimension is large. If set to TRUE, cores will be set to 1 and errors and optimal tuning parameters will based on the full sample. Defaults to FALSE.}

\item{rho}{initial step size for ADMM algorithm.}

\item{mu}{factor for primal and residual norms in the ADMM algorithm. This will be used to adjust the step size \code{rho} after each iteration.}

\item{tau_inc}{factor in which to increase step size \code{rho}}

\item{tau_dec}{factor in which to decrease step size \code{rho}}

\item{crit}{criterion for convergence (\code{ADMM} or \code{loglik}). If \code{crit = loglik} then iterations will stop when the relative change in log-likelihood is less than \code{tol.abs}. Default is \code{ADMM} and follows the procedure outlined in Boyd, et al.}

\item{tol_rel}{relative convergence tolerance. Defaults to 1e-4.}

\item{maxit}{maximum number of iterations. Defaults to 1e4.}

\item{adjmaxit}{adjusted maximum number of iterations. During cross validation this option allows the user to adjust the maximum number of iterations after the first \code{lam} tuning parameter has converged (for each \code{alpha}). This option is intended to be paired with \code{warm} starts and allows for "one-step" estimators. Defaults to 1e4.}

\item{K}{specify the number of folds for cross validation.}

\item{crit_cv}{cross validation criterion (\code{loglik}, \code{AIC}, or \code{BIC}). Defaults to \code{loglik}.}

\item{start}{specify \code{warm} or \code{cold} start for cross validation. Default is \code{warm}.}

\item{trace}{option to display progress of CV. Choose one of \code{progress} to print a progress bar, \code{print} to print completed tuning parameters, or \code{none}.}
}
\value{
list of returns includes:
\item{lam}{optimal tuning parameter.}
\item{alpha}{optimal tuning parameter.}
\item{path}{array containing the solution path. Solutions will be ordered in ascending alpha values for each lambda.}
\item{min.error}{minimum average cross validation error (cv_crit) for optimal parameters.}
\item{avg.error}{average cross validation error (cv_crit) across all folds.}
\item{cv.error}{cross validation errors (cv_crit).}
}
\description{
Cross validation function for ADMMsigma.
}
\keyword{internal}
