\name{plotCalArray} 
\alias{plotCalArray} 
\title{Plots a calibration curve probability array} 
\description{Generates a basic image plot of the calibration curve.}
\usage{plotCalArray(CalArray)}
\arguments{
  \item{CalArray}{
	A 2D probability array of the calibration curve generated by \code{\link[=makeCalArray]{makeCalArray}}, containing row names and column names. 
	}
}
\details{
	Plots CalArray, a 2D probability array of the calibration curve. 

	Time costly if CalArray comprises the entire 50,000 year range of the calibration curve.
	}
\examples{
\donttest{
	# generate a CalArray of the intcal20 curve covering 5500 calBP to 6000 calBP
	x <- makeCalArray( calcurve = intcal20, calrange = c(5500,6000), inc = 1 )
	plotCalArray(x)
	}
	}
	