% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AFMPSDAnalyser.R
\docType{methods}
\name{PSD2DAgainstFrequency}
\alias{PSD2DAgainstFrequency}
\alias{PSD2DAgainstFrequency,AFMImage-method}
\title{Calculate the 2D Power Spectral Density}
\usage{
PSD2DAgainstFrequency(AFMImage)

\S4method{PSD2DAgainstFrequency}{AFMImage}(AFMImage)
}
\arguments{
\item{AFMImage}{an \code{AFMImage} to be analysed}
}
\value{
\code{PSD2DAgainstFrequency} returns a data table of frequencies and PSD values
\itemize{
  \item freq: the considered frequency
  \item PSD: the considered PSD value
  \item type: PSD-2D
  \item fullfilename: directory and filename on the disk
}
}
\description{
PSD2DAgainstFrequency returns a data table of PSD 2D values against spatial frequencies
}
\examples{
\dontrun{
library(AFM)
library(ggplot2)
library(plyr)

# Calculate Power Spectrum Density in 2D against frequency
data("AFMImageOfNormallyDistributedHeights")
oneAFMImage<-AFMImageOfNormallyDistributedHeights
psd2d<-PSD2DAgainstFrequency(oneAFMImage)
p <- ggplot(data=psd2d)
p <- p + geom_point(aes(freq, PSD, color=type),subset = .(type \%in\% c("PSD-2D")))
p <- p + geom_line(aes(freq, PSD, color=type),subset = .(type \%in\% c("PSD-1D")),size=1.1)
p <- p + scale_x_log10()
p <- p + scale_y_log10()
p <- p + ylab("PSD (nm^4)")
p <- p + xlab("Frequency (nm^-1)")
p <- p + ggtitle(basename(oneAFMImage@fullfilename))
p
}
}
\references{
Sidick2009, Erkin Sidick "Power Spectral Density Specification and Analysis of Large Optical Surfaces", 2009, "Modeling Aspects in Optical Metrology II, Proc. of SPIE Vol. 7390 73900L-1"
}

