% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_Raw_Utils.R
\name{check_columns}
\alias{check_columns}
\title{Check if the primary accelerometer file is formatted correctly}
\usage{
check_columns(file, skip, ...)
}
\arguments{
\item{file}{A character scalar giving path to primary accelerometer file}

\item{skip}{number of lines to skip when reading \code{file}}

\item{...}{Arguments passed to \code{\link{read.csv}}}
}
\value{
a logical scalar indicating whether there was only one column
  detected when reading the file
}
\description{
\code{check_columns} returns a logical scalar indicating whether there is a
 formatting issue with the file passed as the argument. A value of TRUE
 indicates the test has passed, whereas FALSE indicates an issue.
}
\examples{
raw_file <-
    system.file("extdata",
    "exampleRAW.csv",
    package = "AGread")

col_check <- check_columns(raw_file, skip = 10)
head(col_check)

}
