% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahr.R
\name{avgHR}
\alias{avgHR}
\title{avgHR}
\usage{
avgHR(L, data, method = "km", ...)
}
\arguments{
\item{L}{time-limit specifying time-interval [0,L] on which average hazard ratios will be calculated}

\item{data}{data frame (see \code{data} argument to \code{\link{ahrWKM}} (if \code{method == "wkm" || "km"}) or \code{\link{ahrAJ}} (if \code{method == "aj"}))}

\item{method}{method used for estimating survival functions (default: Kaplan-Meier estimator)}

\item{...}{additional arguments passed to \code{\link{ahrWKM}} or \code{\link{ahrAJ}}}
}
\value{
An object of class '"ahr"'
}
\description{
Estimate average hazard ratios from k independent samples
}
\details{
This function is a simple wrapper for \code{\link{ahrWKM}} and \code{\link{ahrAJ}}.
}
\examples{
T <- c(rexp(100, 1), rexp(100, 2))
C <- c(rexp(100, 1), rexp(100, 2))
Y <- pmin(T, C)
D <- T <= C
Z <- rep(c(0,1), c(100, 100))
fit <- avgHR(2, data.frame(Y=Y, D=D, Z=Z), formula=Surv(Y, D) ~ Z)
}
\references{
J.~D. Kalbfleisch and R.~L. Prentice. Estimation of the average hazard ratio. \emph{Biometrika}, 68(1):105--112, Apr. 1981.
}
\seealso{
\code{\link{ahrWKM}}, \code{\link{ahrAJ}}
}

