% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_vif.R
\name{filter_vif}
\alias{filter_vif}
\title{Filters out equations with high multicollinearity}
\usage{
filter_vif(all_forms, env_data, ncores = 2, filter = TRUE, verbose = TRUE)
}
\arguments{
\item{all_forms}{A data frame generated by \code{\link{make_models}}}

\item{env_data}{A dataset with the variables described in all_froms}

\item{ncores}{An integer specifying the number of cores to use for parallel processing}

\item{filter}{logical, if TRUE it filters out the models with a maximum VIF of high or higher, if FALSE it generates a new column called collinearity, wich will}

\item{verbose}{logical, defaults TRUE, sends messages about processing times}
}
\value{
A data.frame with the models, fitering out the ones with high collinearity or flagginf them.
}
\description{
This function takes a dataframe with several models and
calculates the maximum Variance Inflation Factor (VIF) for a given
model. And either filters out the ones with high collinearity or it
flags them accordingly
}
\examples{
\donttest{
library(vegan)
data(dune)
data(dune.env)
AllModels <- make_models(vars = c("A1", "Moisture", "Manure"))

filter_vif(all_forms = AllModels,
           env_data = dune.env)
}
}
