% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{numerical_msd}
\alias{numerical_msd}
\title{Compute numerical MSD}
\usage{
numerical_msd(pos, M, len_t)
}
\arguments{
\item{pos}{position matrix for particle trajectory. See 'Details'.}

\item{M}{number of particles}

\item{len_t}{number of time steps}
}
\value{
A vector of numerical MSD for given lag times.
}
\description{
Compute numerical mean squared displacement(MSD) based on particle trajectory.
}
\details{
Input \code{pos} should be the position matrix with dimension
\code{M}\eqn{\times}{\%\times}\code{len_t}. See \code{\link{bm_particle_intensity}},
\code{\link{ou_particle_intensity}}, \code{\link{fbm_particle_intensity}},
\code{\link{fbm_ou_particle_intensity}}.
}
\examples{
library(AIUQ)
# Simulate particle trajectory for BM
M = 10
len_t = 50
mu = 0
sigma = 0.5
pos0 = matrix(100/8+0.75*100*runif(M*2),nrow=M,ncol=2)
pos = bm_particle_intensity(pos0=pos0,M=M,len_t=len_t,mu=mu,sigma=sigma)

# Compute numerical MSD
(num_msd = numerical_msd(pos=pos, M=M, len_t = len_t))
}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
