% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeG.R
\name{computeG}
\alias{computeG}
\title{Foliage projection ratio G(theta).}
\usage{
computeG(
  theta,
  pdf = "spherical",
  chi,
  mu,
  nu,
  with.lut = length(theta) > 100,
  lut.precision = 0.001
)
}
\arguments{
\item{theta}{a numeric vector, theta, the incident beam inclination, in radian,
ranging \verb{[0, pi/2]}.}

\item{pdf}{the name of the probability density function of the leaf angle
distribution. One of "uniform", "spherical", "planophile", "erectophile",
"plagiophile", "extremophile", "ellipsoidal", "twoParamBeta". Refer to
section "Leaf Angle Distribution functions" for details.}

\item{chi}{a float, parameter of the ellipsoidal leaf angle distribution.
The ratio the ratio horizontal axis over vertical axis. See section "Leaf
Angle Ditribution functions" for details.}

\item{mu}{a float, parameter controlling the Beta distribution. See section
"Leaf Angle Distribution functions" for details.}

\item{nu}{a float, parameter controlling the Beta distribution. See section
"Leaf Angle Distribution functions" for details.}

\item{with.lut}{a Boolean, whether to estimate G with a lookup table (LUT).
By default the lookup table is automatically generated when length of theta
vector is greater than 100.}

\item{lut.precision}{a float, the increment of the theta sequence ranging
from 0 to pi/2 for computing the lookup table.}
}
\description{
Compute the mean projection of unit leaf area on the plane
perpendicular to beam direction, namely, G(theta) parameter. Assumption of
symmetric distribution of leaf azimuth angle.
When estimating G for large amount of theta values, it is advised to enable
the lookup table for speeding up the calculation.
}
\details{
Leaf Angle Distribution functions
\itemize{
\item de Wit’s leaf angle distribution functions:
\itemize{
\item \strong{uniform}, proportion of leaf angle is the same at any angle
\item \strong{spherical}, relative frequency of leaf angle is the same as for
surface elements of a sphere
\item \strong{planophile}, horizontal leaves most frequent
\item \strong{erectophile}, vertical leaves most frequent
\item \strong{plagiophile}, oblique leaves most frequent
\item \strong{extremophile}, oblique leaves least frequent
}
\item \strong{ellipsoidal} distribution function, generalization of the spherical
distribution over an ellipsoid. Relative frequency of leaf angle is the same
as for surface elements of an ellipsoid. Takes one parameter \code{chi} the ratio
horizontal axis over vertical axis. For \code{chi = 1} the distribution becomes
spherical. For \code{chi < 1}, the ellipsoid is a prolate spheroid (like a
rugby ball). For \code{chi > 1} the ellipsoid is an oblate spheroid (a sphere that
bulges at the equator and is somewhat squashed at the poles).
\item \strong{two parameters Beta} distribution. Most generic approach from Goal
and Strebel (1984) to represent large variety of leaf angle distribution. Takes
two parameters \code{mu} and \code{nu} that control the shape of the Beta
distribution.
}
}
\examples{
# G(theta) == 0.5 for spherical distribution
all(computeG(theta = runif(10, 0, pi/2)) == 0.5) # returns TRUE
# ellipsoidal distribution
computeG(theta = runif(10, 0, pi/2), pdf = "ellipsoidal", chi = 0.6)
}
\references{
Wang, W. M., Li, Z. L., & Su, H. B. (2007).
Comparison of leaf angle distribution functions: effects on extinction
coefficient and fraction of sunlit foliage. Agricultural and Forest
Meteorology, 143(1), 106-122.
}
\seealso{
\code{\link[=plotG]{plotG()}} for plotting G(theta) profiles
}
