% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/like.R
\name{like}
\alias{like}
\alias{\%like\%}
\alias{\%unlike\%}
\alias{\%like_case\%}
\alias{\%unlike_case\%}
\title{Vectorised Pattern Matching with Keyboard Shortcut}
\source{
Idea from the \href{https://github.com/Rdatatable/data.table/blob/ec1259af1bf13fc0c96a1d3f9e84d55d8106a9a4/R/like.R}{\code{like} function from the \code{data.table} package}, although altered as explained in \emph{Details}.
}
\usage{
like(x, pattern, ignore.case = TRUE)

x \%like\% pattern

x \%unlike\% pattern

x \%like_case\% pattern

x \%unlike_case\% pattern
}
\arguments{
\item{x}{a \link{character} vector where matches are sought, or an object which can be coerced by \code{\link[=as.character]{as.character()}} to a \link{character} vector.}

\item{pattern}{a \link{character} vector containing regular expressions (or a \link{character} string for \code{fixed = TRUE}) to be matched in the given \link{character} vector. Coerced by \code{\link[=as.character]{as.character()}} to a \link{character} string if possible.}

\item{ignore.case}{if \code{FALSE}, the pattern matching is \emph{case sensitive} and if \code{TRUE}, case is ignored during matching.}
}
\value{
A \link{logical} vector
}
\description{
Convenient wrapper around \code{\link[=grepl]{grepl()}} to match a pattern: \code{x \%like\% pattern}. It always returns a \code{\link{logical}} vector and is always case-insensitive (use \code{x \%like_case\% pattern} for case-sensitive matching). Also, \code{pattern} can be as long as \code{x} to compare items of each index in both vectors, or they both can have the same length to iterate over all cases.
}
\details{
These \code{\link[=like]{like()}} and \verb{\%like\%}/\verb{\%unlike\%} functions:
\itemize{
\item Are case-insensitive (use \verb{\%like_case\%}/\verb{\%unlike_case\%} for case-sensitive matching)
\item Support multiple patterns
\item Check if \code{pattern} is a valid regular expression and sets \code{fixed = TRUE} if not, to greatly improve speed (vectorised over \code{pattern})
\item Always use compatibility with Perl unless \code{fixed = TRUE}, to greatly improve speed
}

Using RStudio? The \verb{\%like\%}/\verb{\%unlike\%} functions can also be directly inserted in your code from the Addins menu and can have its own keyboard shortcut like \code{Shift+Ctrl+L} or \code{Shift+Cmd+L} (see menu \code{Tools} > \verb{Modify Keyboard Shortcuts...}). If you keep pressing your shortcut, the inserted text will be iterated over \verb{\%like\%} -> \verb{\%unlike\%} -> \verb{\%like_case\%} -> \verb{\%unlike_case\%}.
}
\examples{
a <- "This is a test"
b <- "TEST"
a \%like\% b
b \%like\% a

# also supports multiple patterns
a <- c("Test case", "Something different", "Yet another thing")
b <- c("case", "diff", "yet")
a \%like\% b
a \%unlike\% b

a[1] \%like\% b
a \%like\% b[1]

\donttest{
# get isolates whose name start with 'Entero' (case-insensitive)
example_isolates[which(mo_name() \%like\% "^entero"), ]

if (require("dplyr")) {
  example_isolates \%>\%
    filter(mo_name() \%like\% "^ent")
}
}
}
\seealso{
\code{\link[=grepl]{grepl()}}
}
